//
//  OPSyncState.h
//  OnePasswordiOS
//
//  Created by Dave Teare on 12-04-14.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "OPDatabaseObject.h"

@class OPSyncSource;

@interface OPSyncState : NSObject

// [rfillion 2015-02-23] SyncSource contains SyncStates, so this needs to be weak otherwise we have a cycle.
@property (nonatomic, weak) OPSyncSource * source;

@property (nonatomic) OPID objectID;
@property (nonatomic, copy) NSString * objectUUID;
@property (nonatomic) OPObjectType objectType;
@property (nonatomic) OPTimestamp syncedAt;
@property (nonatomic) OPTimestamp sourceTimestamp;
@property (nonatomic) OPTimestamp localTimestamp;

- (NSDictionary *)asDictionary;

@end
